//%attributes = {}
// Method: ldcap_ IMPORT 
// 26.01.11, 02:23:18 / MG_PM
// © Copyright Manage Applications
// Purpose: 
// called from: ldcap_ IMPORT_ALL
// ------------------------------------------------------------
If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 

C_TEXT:C284($1; $ldcap_tFolderPath; $ldcap_tPath; $2; $ldcap_tLoadGroup; $ldcap_tLoadGroupMachine)
C_DATE:C307($3; $ldcap_dStartDate; $4; $ldcap_dEndDate; $ldcap_dDateCurrent)

C_TEXT:C284($ldcap_tPattern; $ldcap_tFile; $ldcap_tDayName; $ldcap_tInfo; $ldcap_tWorkCalendar)
C_LONGINT:C283($ldcap_lWeek; $ldcap_lDayNum; $ldcap_lStart; $ldcap_lRow; $ldcap_lStartRow; $ldcap_lIndex; $ldcap_lCount)
C_LONGINT:C283($ldcap_lFoundPos; $ldcap_lFoundPosLength; $ldcap_lStartTime; $ldcap_lTimeCurrent)
C_LONGINT:C283($ldcap_lArrLoadType; $ldcap_lShift; $ldcap_lShiftIndex; $ldcap_lShiftCount; $ldcap_lLoaded; $ldcap_lLoadType)
C_REAL:C285($ldcap_rStart)
C_BLOB:C604($ldcap_xFile; $ldcap_xBlobOld; $ldcap_xBlobNew)
C_BOOLEAN:C305($ldcap_fFound)
C_TIME:C306($ldcap_hStartTime; $ldcap_hEndTime)
C_LONGINT:C283($ldcap_lShiftErrStartMessage; $ldcap_lShiftErrEndMessage)
$ldcap_lShiftErrStartMessage:=kFalse
$ldcap_lShiftErrEndMessage:=kFalse
ARRAY REAL:C219($ldcap_arShiftStart; 0)
ARRAY REAL:C219($ldcap_arShiftEnd; 0)
ARRAY LONGINT:C221($ldcap_alShiftNum; 0)

COMPILER_ldcap_

$ldcap_tFolderPath:=$1
$ldcap_tLoadGroup:=$2
$ldcap_tLoadGroupMachine:=$ldcap_tLoadGroup+"_machine"
$ldcap_dStartDate:=$3
$ldcap_dEndDate:=$4

$ldcap_lArrLoadType:=cap_ ArrLoadType($ldcap_tLoadGroup)
If ($ldcap_lArrLoadType#0)
	cap_ ARR_LOAD_TYPE_SET(0)
End if 

$ldcap_dDateCurrent:=_date Current(kTrue)
$ldcap_lTimeCurrent:=_time ToLongint(_time Current(kTrue))


ARRAY TEXT:C222(ldcap_atBrushColorId; 0)  // force reload of prf
ARRAY TEXT:C222(ldcap_atBrushColor; 0)
ARRAY TEXT:C222(ldcap_atBrushInfo; 0)
ARRAY LONGINT:C221(ldcap_alBrushInRunRatio; 0)

If ($ldcap_tLoadGroup="")
	$ldcap_tLoadGroup:=_info_ Request(_lang Current("Give load group"); "")
End if 
If ($ldcap_tFolderPath="")
	$ldcap_tFolderPath:=_doc FolderChoose(_lang Current("Give document folder"); "")
End if 

If (Test path name:C476($ldcap_tFolderPath)=Is a folder:K24:2)
	
	If ($ldcap_dStartDate=!00-00-00!)
		$ldcap_dStartDate:=$ldcap_dDateCurrent
		_info_ TIME_PERIOD_ASK(_lang Current("Give document dates"); $ldcap_dStartDate; $ldcap_dStartDate)
		If (OK=1)
			_info_ TIME_PERIOD_DATES_GET(->$ldcap_dStartDate; ->$ldcap_dEndDate)
		Else 
			$ldcap_dStartDate:=!00-00-00!
		End if 
		
	End if 
	
	If ($ldcap_dStartDate#!00-00-00!)
		
		// load new resource capacity to cap arrays
		ldcap_ NEXT_LOAD_FORCE
		ldcap_ARR_LOAD_SAVE(kLoad; $ldcap_tLoadGroupMachine; kTrue)
		
		If (ldcap_ MachineDataLoadType=0)  // 0 = old code
			
			_arr apBlob(kSave; ->$ldcap_xBlobOld; ->ldcap_apCapArr)
			
			// AK 2014-09-04
			$ldcap_tWorkCalendar:=$ldcap_tLoadGroup
			$ldcap_lLoaded:=kFalse
			$ldcap_lLoadType:=cap_ ArrLoadType($ldcap_tWorkCalendar)
			If ($ldcap_lLoadType>0)
				$ldcap_lLoaded:=cap_ ShiftLimitArrLoad($ldcap_tWorkCalendar; $ldcap_dStartDate-1; $ldcap_dEndDate+1)
			End if 
			If ($ldcap_lLoaded=kFalse)  // old shift loading code
				ldcap_ NEXT_LOAD_FORCE
				$ldcap_tWorkCalendar:=wlg_ WorkCalendar($ldcap_tLoadGroup)  // find lg's new resource capacity for shift calculation
				res_ CAPACITY_LOAD($ldcap_tWorkCalendar; $ldcap_dStartDate-1; $ldcap_dEndDate+1; kTrue)  // or $ldcap_dStartDate-1;$ldcap_dEndDate+1 // -1 and +1 just to be sure
			End if 
			
			COPY ARRAY:C226(ldcap_arStart; $ldcap_arShiftStart)
			COPY ARRAY:C226(ldcap_arEnd; $ldcap_arShiftEnd)
			COPY ARRAY:C226(ldcap_alShift; $ldcap_alShiftNum)
			$ldcap_lShiftCount:=Size of array:C274($ldcap_arShiftStart)
			If ($ldcap_lShiftCount<1)
				_err MESSAGE(_lang Current("Work calendar size is zero")+": "+$ldcap_tWorkCalendar; Current method name:C684; kFalse)
			End if 
			
			ldcap_ NEXT_LOAD_FORCE
			_arr apRESIZE(->ldcap_apCapArr; 0)
			
			$ldcap_tFolderPath:=_doc_ FolderSeparatorToEndAdd($ldcap_tFolderPath)
			While ($ldcap_dStartDate<=$ldcap_dEndDate)
				$ldcap_tPath:=$ldcap_tFolderPath+String:C10(Year of:C25($ldcap_dStartDate))  // 4 numbers
				$ldcap_lWeek:=_date ToWeek($ldcap_dStartDate)
				$ldcap_tPath:=$ldcap_tPath+String:C10($ldcap_lWeek-(Year of:C25($ldcap_dStartDate)*100))  // may be 1 or 2 numbers
				$ldcap_tPath:=$ldcap_tPath+String:C10(_date_ DayNumberFromMonday($ldcap_dStartDate))  // 1=monday, 7=sunday
				$ldcap_tPath:=$ldcap_tPath+".log"
				
				If (Test path name:C476($ldcap_tPath)=Is a document:K24:1)
					
					Error:=0
					_onerr CALL("_onerr_IDLE")
					DOCUMENT TO BLOB:C525($ldcap_tPath; $ldcap_xFile)  // on err call around this
					_onerr CALL("")
					If (Error#0)
						_err MESSAGE(_lang Current("Reading failed from file")+": "+ksQuoteStart+$ldcap_tPath+ksQuoteEnd; Current method name:C684; kFalse)
					End if 
					
					// if(Blob Size($ldcap_xFile)=prevsize)
					//   if(_blob_ MD5Checksum(->$ldcap_xFile)=prevMD5)
					
					$ldcap_tFile:=Convert to text:C1012($ldcap_xFile; "ISO-8859-15")
					SET BLOB SIZE:C606($ldcap_xFile; 0)
					$ldcap_lRow:=1
					$ldcap_tDayName:=_date ToDayname($ldcap_dStartDate)
					$ldcap_lDayNum:=Day number:C114($ldcap_dStartDate)
					
					$ldcap_dNullDate:=!00-00-00!
					_arr_ apFOUND_VALUE_DELETE(->ldcap_apCapArr; ->ldcap_adStartDate; ->$ldcap_dNullDate)  // delete null day rows
					
					$ldcap_lRow:=Find in array:C230(ldcap_adStartDate; $ldcap_dStartDate)
					If ($ldcap_lRow>0)
						_arr_ apFOUND_VALUE_DELETE(->ldcap_apCapArr; ->ldcap_adStartDate; ->$ldcap_dStartDate)  // delete all same day rows
					Else 
						$ldcap_lRow:=Size of array:C274(ldcap_adStartDate)+1
					End if 
					
					If ($ldcap_lRow<1)
						$ldcap_lRow:=1
					End if 
					
					$ldcap_lCount:=_str AsciiCount($ldcap_tFile; ksLF)
					If ($ldcap_lCount=0)
						$ldcap_lCount:=_str AsciiCount($ldcap_tFile; ksCR)
						If (Substring:C12($ldcap_tFile; Length:C16($ldcap_tFile))#ksCR)
							$ldcap_lCount:=$ldcap_lCount+1
						End if 
					Else 
						If (Substring:C12($ldcap_tFile; Length:C16($ldcap_tFile))#ksLF)
							$ldcap_lCount:=$ldcap_lCount+1
						End if 
					End if 
					_arr apINSERT(->ldcap_apCapArr; $ldcap_lRow; $ldcap_lCount)
					
					$ldcap_lStart:=1
					$ldcap_tPattern:="(?m:^(.*)$)"  // ?m: = directive to use multiline mode maybe?, ^(.*)$ = from start of row(^) any(.) repeated(*) = (.*) chars to end of row($)
					$ldcap_fFound:=True:C214
					$ldcap_lStartRow:=$ldcap_lRow
					
					For ($ldcap_lIndex; 1; $ldcap_lCount)
						
						$ldcap_fFound:=Match regex:C1019($ldcap_tPattern; $ldcap_tFile; $ldcap_lStart; $ldcap_lFoundPos; $ldcap_lFoundPosLength)
						
						//If (Not($ldcap_fFound))
						//IDLE  // end found
						//Else)
						$ldcap_tRow:=Substring:C12($ldcap_tFile; $ldcap_lStart; $ldcap_lFoundPosLength)
						$ldcap_lStart:=$ldcap_lFoundPos+$ldcap_lFoundPosLength+1
						$ldcap_tRow:=Replace string:C233($ldcap_tRow; ksCR; "")
						$ldcap_tRow:=Replace string:C233($ldcap_tRow; ksLF; "")
						
						If ($ldcap_tRow#"")
							$ldcap_tInfo:=_str Parse($ldcap_tRow; ";"; 1)  // use $ldcap_tInfo as temp var
							$ldcap_hStartTime:=Time:C179($ldcap_tInfo)
							
							$ldcap_tInfo:=_str EndParse($ldcap_tRow; ";"; 1)
							//End if 
							
							$ldcap_lStartTime:=$ldcap_hStartTime*1  // _time ToLongint
							While (($ldcap_lStartTime<=ldcap_ahStartTime{$ldcap_lRow-1}) & ($ldcap_lRow>$ldcap_lStartRow))
								If ($ldcap_lStartTime<ldcap_ahStartTime{$ldcap_lRow-1})
									_err MESSAGE(_lang Current("Found overlapping row from file")+": "+ksQuoteStart+$ldcap_tPath+ksQuoteEnd+": "+String:C10($ldcap_dStartDate)+", "+String:C10(_long ToTime($ldcap_lStartTime))+" < "+_lang Current("prev. row")+ksSpace+String:C10(_long ToTime(ldcap_ahStartTime{$ldcap_lRow-1})); Current method name:C684; kFalse)
								End if 
								$ldcap_lRow:=$ldcap_lRow-1  // override previous row with new one
							End while 
							
							ldcap_adStartDate{$ldcap_lRow}:=$ldcap_dStartDate
							ldcap_alStartWeek{$ldcap_lRow}:=$ldcap_lWeek
							ldcap_atStartDayName{$ldcap_lRow}:=$ldcap_tDayName
							ldcap_ahStartTime{$ldcap_lRow}:=$ldcap_lStartTime  // _time ToLongint
							ldcap_adEndDate{$ldcap_lRow}:=$ldcap_dStartDate
							
							
							If ($ldcap_lIndex=1)
								If (($ldcap_lRow=$ldcap_lStartRow) & ($ldcap_lRow>1))
									// fix prev day last +4*7 days = weeks
									ldcap_adEndDate{$ldcap_lRow-1}:=$ldcap_dStartDate
									ldcap_ahEndTime{$ldcap_lRow-1}:=ldcap_ahStartTime{$ldcap_lRow}
								End if 
							Else 
								ldcap_ahEndTime{$ldcap_lRow-1}:=ldcap_ahStartTime{$ldcap_lRow}  // _time ToLongint
							End if 
							
							
							ldcap_arMultiplier{$ldcap_lRow}:=1
							ldcap_arCurrentFree{$ldcap_lRow}:=0
							ldcap_arCumulativeFree{$ldcap_lRow}:=0
							ldcap_arMaxWorkMultiplier{$ldcap_lRow}:=1
							ldcap_atCapId{$ldcap_lRow}:=""
							ldcap_alWeekday{$ldcap_lRow}:=$ldcap_lDayNum
							ldcap_atColor{$ldcap_lRow}:=_str Parse($ldcap_tInfo; ";"; 1)
							ldcap_atColor{$ldcap_lRow}:=ldcap_ InfoToBrushColor(1; "ldcap_InfoToBrushColor"; ldcap_atColor{$ldcap_lRow})  // change type to color
							
							//ldcap_atInfo{$ldcap_lRow}:=ldcap_ InfoToBrushColor (2;"ldcap_InfoToBrushColor";ldcap_atColor{$ldcap_lRow})  // change type to info
							//$ldcap_tInfo:=_str EndParse ($ldcap_tInfo;";";1)
							//If (($ldcap_tInfo#";") & ($ldcap_tInfo#""))
							//ldcap_atInfo{$ldcap_lRow}:=ldcap_atInfo{$ldcap_lRow}+$ldcap_tInfo
							//End if 
							ldcap_atInfo{$ldcap_lRow}:=$ldcap_tRow
							//ldcap_alShift{$ldcap_lRow}:=$ldcap_lShift // later in loop
							
							//in: ldcap_ArrCheck
							//ldcap_arStart{$ldcap_lIndex}:=_dt ToReal (ldcap_adStartDate{$ldcap_lIndex};ldcap_ahStartTime{$ldcap_lIndex})
							//ldcap_arEnd{$ldcap_lIndex}:=_dt ToReal (ldcap_adEndDate{$ldcap_lIndex};ldcap_ahEndTime{$ldcap_lIndex})
							//ldcap_arDuration{$ldcap_lIndex}:=_dt Difference (ldcap_arEnd{$ldcap_lIndex};ldcap_arStart{$ldcap_lIndex})
							//ldcap_arCapacity{$ldcap_lIndex}:=ldcap_arMultiplier{$ldcap_lIndex}*ldcap_arDuration{$ldcap_lIndex}
							$ldcap_lRow:=$ldcap_lRow+1
						End if 
						
					End for 
					
					$ldcap_lRow:=$ldcap_lRow-1  // $ldcap_lRow:=$ldcap_lRow+1 at the end of for loop
					_arr apRESIZE(->ldcap_apCapArr; $ldcap_lRow)
					
					If (Not:C34($ldcap_fFound))
						_err MESSAGE(_lang Current("Found less than expected rows from file")+": "+ksQuoteStart+$ldcap_tPath+ksQuoteEnd; Current method name:C684; kFalse)
					Else 
						If ($ldcap_lStart<Length:C16($ldcap_tFile))
							$ldcap_fFound:=Match regex:C1019($ldcap_tPattern; $ldcap_tFile; $ldcap_lStart; $ldcap_lFoundPos; $ldcap_lFoundPosLength)
							If ($ldcap_fFound)
								_err MESSAGE(_lang Current("Found more than expected rows from file")+": "+ksQuoteStart+$ldcap_tPath+ksQuoteEnd; Current method name:C684; kFalse)
							End if 
						End if 
					End if 
					
					
				End if 
				
				If (ldcap_adEndDate{$ldcap_lRow}#$ldcap_dDateCurrent)
					ldcap_adEndDate{$ldcap_lRow}:=ldcap_adEndDate{$ldcap_lRow}+(4*7)  // add 4 weeks more date
					ldcap_ahEndTime{$ldcap_lRow}:=_time ToLongint(?23:59:59?)
				End if 
				
				$ldcap_dStartDate:=$ldcap_dStartDate+1
				
			End while 
			
			If (ldcap_adEndDate{$ldcap_lRow}=$ldcap_dDateCurrent)
				If (ldcap_ahEndTime{$ldcap_lRow-1}>$ldcap_lTimeCurrent)
					ldcap_ahEndTime{$ldcap_lRow}:=ldcap_ahEndTime{$ldcap_lRow-1}+1  // add 1 second
				Else 
					ldcap_ahEndTime{$ldcap_lRow}:=$ldcap_lTimeCurrent  // stop today to current time
				End if 
			End if 
			
			$ldcap_lCount:=Size of array:C274(ldcap_adEndDate)  // find current moment from end
			While (($ldcap_lCount>1) & (ldcap_adEndDate{$ldcap_lCount}>=$ldcap_dDateCurrent) & (ldcap_ahStartTime{$ldcap_lCount}>$ldcap_lTimeCurrent) & (ldcap_ahEndTime{$ldcap_lCount}>$ldcap_lTimeCurrent))
				$ldcap_lCount:=$ldcap_lCount-1
			End while 
			If ($ldcap_lCount<$ldcap_lRow)
				$ldcap_lRow:=$ldcap_lCount  // remove future rows
				_arr apRESIZE(->ldcap_apCapArr; $ldcap_lRow)
			End if 
			
			If (ldcap_adEndDate{$ldcap_lRow}=$ldcap_dDateCurrent)
				//ldcap_adEndDate{$ldcap_lRow}:=ldcap_adEndDate{$ldcap_lRow}+(4*7)  // add 4 weeks more date?
				If ($ldcap_lTimeCurrent>ldcap_ahStartTime{$ldcap_lRow})
					ldcap_ahEndTime{$ldcap_lRow}:=$ldcap_lTimeCurrent
				Else 
					ldcap_ahEndTime{$ldcap_lRow}:=ldcap_ahStartTime{$ldcap_lRow}
				End if 
				
				// add white cap to the end
				$ldcap_lRow:=$ldcap_lRow+1
				If (Size of array:C274(ldcap_adEndDate)<$ldcap_lRow)
					_arr apINSERT(->ldcap_apCapArr; $ldcap_lRow; 1)
				End if 
				
				ldcap_adStartDate{$ldcap_lRow}:=ldcap_adEndDate{$ldcap_lRow-1}
				ldcap_alStartWeek{$ldcap_lRow}:=0
				ldcap_atStartDayName{$ldcap_lRow}:=""
				ldcap_ahStartTime{$ldcap_lRow}:=ldcap_ahEndTime{$ldcap_lRow-1}+?00:00:01?  // _time ToLongint
				
				ldcap_adEndDate{$ldcap_lRow}:=ldcap_adStartDate{$ldcap_lRow}+(4*7)  // add 4 weeks more date
				ldcap_ahEndTime{$ldcap_lRow}:=_time ToLongint(?23:59:59?)
				
				ldcap_arMultiplier{$ldcap_lRow}:=1
				ldcap_arCurrentFree{$ldcap_lRow}:=0
				ldcap_arCumulativeFree{$ldcap_lRow}:=0
				ldcap_arMaxWorkMultiplier{$ldcap_lRow}:=1
				ldcap_atCapId{$ldcap_lRow}:=""
				ldcap_alWeekday{$ldcap_lRow}:=0
				ldcap_atInfo{$ldcap_lRow}:=""
				//ldcap_atColor{$ldcap_lRow}:="white:90"
				ldcap_atColor{$ldcap_lRow}:=ldcap_ InfoToBrushColor(1; "ldcap_InfoToBrushColor"; "-1")
				ldcap_alShift{$ldcap_lRow}:=-1
				
			End if 
			
			// set shift num
			If ($ldcap_lShiftCount>0)
				// how about end shift, where to store it?
				$ldcap_lCount:=Size of array:C274(ldcap_adStartDate)
				For ($ldcap_lRow; 1; $ldcap_lCount)
					$ldcap_dStartDate:=ldcap_adStartDate{$ldcap_lRow}
					$ldcap_hStartTime:=ldcap_ahStartTime{$ldcap_lRow}
					$ldcap_lShift:=<>ldcap_lMachineUnknownShift  // not inside any shift
					$ldcap_rStart:=_dt ToReal($ldcap_dStartDate; $ldcap_hStartTime)
					For ($ldcap_lShiftIndex; 1; $ldcap_lShiftCount)
						If (($ldcap_rStart>=$ldcap_arShiftStart{$ldcap_lShiftIndex}) & ($ldcap_rStart<=$ldcap_arShiftEnd{$ldcap_lShiftIndex}))
							$ldcap_lShift:=$ldcap_alShiftNum{$ldcap_lShiftIndex}  // save found shift num
							$ldcap_lShiftIndex:=$ldcap_lShiftCount+1  // end loop
						End if 
					End for 
					If ($ldcap_lShift=<>ldcap_lMachineUnknownShift)
						Case of 
							: ($ldcap_rStart<$ldcap_arShiftStart{1}) & ($ldcap_lShiftErrStartMessage=kFalse)
								$ldcap_lShiftErrStartMessage:=kTrue
								_err MESSAGE(_lang Current("Start time is smaller than work phase calendar start time")+": "+_dt RealToDateTimeString($ldcap_rStart); Current method name:C684; kFalse)
							: ($ldcap_rStart>$ldcap_arShiftEnd{$ldcap_lShiftCount}) & ($ldcap_lShiftErrEndMessage=kFalse)
								$ldcap_lShiftErrEndMessage:=kTrue
								_err MESSAGE(_lang Current("Start time is bigger than work phase calendar end time")+": "+_dt RealToDateTimeString($ldcap_rStart); Current method name:C684; kFalse)
							Else 
								IDLE:C311  // all ok
						End case 
					End if 
					ldcap_alShift{$ldcap_lRow}:=$ldcap_lShift
				End for 
			End if 
			
			If (ldcap_ArrCheck=kTrue)
				_arr apBlob(kSave; ->$ldcap_xBlobNew; ->ldcap_apCapArr)
				If (_blob_ Equal(->$ldcap_xBlobOld; ->$ldcap_xBlobNew)=kFalse)
					ldcap_ARR_LOAD_SAVE(kSave; $ldcap_tLoadGroupMachine; kTrue)
					_cron_ MESSAGE(0; _lang Current("Created automatic machine capacity")+": "+$ldcap_tLoadGroupMachine+", "+String:C10(Size of array:C274(ldcap_arStart))+ksSpace+_lang Current("rows"))
				Else 
					_cron_ MESSAGE(0; _lang Current("Created automatic machine capacity")+": "+$ldcap_tLoadGroupMachine)
				End if 
			Else   // error also before
				_err MESSAGE(_lang Current("Found overlapping rows from file")+": "+ksQuoteStart+$ldcap_tPath+ksQuoteEnd; Current method name:C684; kFalse)
			End if 
			
		End if 
	End if 
End if 

//End if 
If ($ldcap_lArrLoadType#0)
	cap_ ARR_LOAD_TYPE_SET($ldcap_lArrLoadType)
End if 

If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 